﻿using System.Collections.Generic;

namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for providing a summary for a selected patient.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
    /// </history>
    public class PatientSummaryViewModel : PcehrViewModelBase
    {

        #region Properties

        /// <summary>
        /// Gets or sets the document categories for the documents available for a selected patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public List<DocumentCategoryViewModel> DocumentCategories { get; internal set; }

        /// <summary>
        /// Gets or sets the list of documents for a selected patient.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public List<DocumentViewModel> Documents { get; internal set; }

        /// <summary>
        /// Gets or sets the count of prescription and dispense documents for a selected patient.
        /// </summary>
        /// <history>
        ///   <change user="Matt Mitchell (Chamonix)" date="16 January 2014">Initial version.</change>
        /// </history>
        public int PrescriptionDispenseDocumentCount { get; internal set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public PatientSummaryViewModel()
        {
            this.DocumentCategories = new List<DocumentCategoryViewModel>();
            this.Documents = new List<DocumentViewModel>();
        }

        #endregion

    }
}

